﻿//---------------------------------------------------------------------------------
// Microsoft (R) .NET Services SDK
// Software Development Kit
// 
// Copyright (c) Microsoft Corporation. All rights reserved.  
//
// THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, 
// EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
// OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE. 
//---------------------------------------------------------------------------------

namespace Microsoft.AccessControl.ASPNET
{
    using System;
    using System.Collections.Generic;
    using System.Collections.Specialized;
    using System.Linq;
    using System.Security.Principal;
    using System.Text;

    public sealed class ServiceIdentity : IIdentity
    {
        private string authenticationTypeString = "ACSToken";
        private bool isAuthenticated = false;
        private Dictionary<string, string> claims;

        private string username;

        internal ServiceIdentity(string token, TokenValidator validator)
        {
            // if the token is valid, they are authenticated
            this.isAuthenticated = false;

            this.claims = validator.GetNameValues(token);

            if (this.claims.TryGetValue("name", out this.username))
            {
                this.isAuthenticated = true;
            }
        }

        public string AuthenticationType
        {
            get
            {
                return this.authenticationTypeString;
            }
        }

        public bool IsAuthenticated
        {
            get { return this.isAuthenticated; }
        }

        public string Name
        {
            get { return this.username; }
        }

        public Dictionary<string, string> Claims
        {
            get { return this.claims; }
        }
    }
}
